#include <windows.h>
#include <dsound.h>
#include <stdio.h>
#include "audio.h"

#define MI_INTR_AI			0x04			/* Bit 2: AI intr */
AUDIO_INFO AudioInfo;


EXPORT void CALL AiDacrateChanged (int SystemType) {
}

EXPORT void CALL AiLenChanged (void) {
	if (*AudioInfo.AI_LEN_REG == 0) { return; }
	*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
	AudioInfo.CheckInterrupts();
}

EXPORT DWORD CALL AiReadLength (void) {
	return 0;
}

EXPORT void CALL AiUpdate (BOOL Wait) {
	if (Wait) {
		WaitMessage();
	}
}

EXPORT void CALL CloseDLL (void) {
}

void DisplayError (char * Message, ...) {
	char Msg[400];
	va_list ap;

	va_start( ap, Message );
	vsprintf( Msg, Message, ap );
	va_end( ap );
	MessageBox(NULL,Msg,"Error",MB_OK|MB_ICONERROR);
}

EXPORT void CALL DllAbout ( HWND hParent ) {
	DisplayError ("No Sound by zilmar");
}

EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo ){ 
	PluginInfo->Version = 0x0101;
	PluginInfo->Type    = PLUGIN_TYPE_AUDIO;
	sprintf(PluginInfo->Name,"No Sound");
	PluginInfo->NormalMemory  = TRUE;
	PluginInfo->MemoryBswaped = TRUE;
}

EXPORT BOOL CALL InitiateAudio (AUDIO_INFO Audio_Info) {
	AudioInfo = Audio_Info;
	return TRUE;
}

EXPORT void CALL ProcessAList(void) {
}

EXPORT void CALL RomClosed (void) {
}

